package org.msh.tb.reports2.me;

import org.msh.tb.reports2.ReportResources;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class SputumConversionReport {


    public static List<TableData> generate(IndicatorBuilder builder) {
        List<TableData> tables = new ArrayList<TableData>();


        tables.add(generateBlock1(builder));
        tables.add(generateBlock2(builder.clear()));

        return tables;
    }


    public static TableData generateBlock1(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(//"totalcases key=1:\"Total enrolled\"," +
                        "groups DONE='Smear done' NOTDONE='Smear not done'," +
                        "totalcases mic_resdiag='POSITIVE;PLUS;PLUS2;PLUS3;PLUS4' key=1:'Total cases enrolled'," +
                        "mic-res-group mic-res-group='POSITIVE;NEGATIVE' key=POSITIVE:'Positive' key=NEGATIVE:'Negative' group=DONE," +
                        "state state='ONTREATMENT;DIED' key=1:'Continuing treatment' group=NOTDONE mic_resdiag='isnull'," +
                        "totalcases key=1:'Total cases reported'")
                .addRowVariables("sputum-conv")
                .addFilter(ReportResources.VAR_XPERT_RESULT_DIAG, "TB_DETECTED")
                .addFilter(ReportResources.VAR_INFECTIONSITE, "PULMONARY;BOTH")
                .generate("Block 1: Breakdown of Xpert Positive PTB cases registered in quarter by month 2 of AFB result");

        return tbl;
    }

    public static TableData generateBlock2(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(//"totalcases key=1:\"Total enrolled\"," +
                        "groups DONE='Smear done' NOTDONE='Smear not done'," +
                                "totalcases mic_resdiag='POSITIVE;PLUS;PLUS2;PLUS3;PLUS4' key=1:'Total cases enrolled'," +
                                "mic-res-group mic-res-group='POSITIVE;NEGATIVE' key=POSITIVE:'Positive' key=NEGATIVE:'Negative' group=DONE," +
                                "state state='ONTREATMENT;DIED' key=1:'Continuing treatment' group=NOTDONE mic_resdiag='isnull'," +
                                "totalcases key=1:'Total cases reported'")
                .addRowVariables("sputum-conv")
                .addFilter(ReportResources.VAR_INFECTIONSITE, "PULMONARY;BOTH")
                .generate("Block 2: Breakdown of Smear Positive PTB cases registered in quarter by month 2 of AFB result");

        return tbl;
    }
}
